<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class TabellaPrezzi {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato          = $spazioOccupato;
        }
        
        function crea() {
            $query    = "INSERT INTO geec_tabellePrezzi VALUES(NULL,'$this->nome','$this->spazioOccupato')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_tabellePrezzi SET nome='$this->nome', spazioOccupato='$this->spazioOccupato' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_tabellePrezzi",$this->id);
            
            // elimina le occorrenze di questo componente nelle pagine, l'id di questo componente è 30
            $queryEliminaOccorrenzeComposizionePagine = "DELETE FROM geecB_composizionePagine WHERE idElemento = $this->id AND idComponente = 30";
            $this->db->eseguiQueryScrittura($queryEliminaOccorrenzeComposizionePagine);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_visualizzatoreProfili VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_colonneTabellaPrezzi WHERE idTabella='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_colonneTabellaPrezzi` (`id`, `idTabella`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiTabella          = $this->db->leggiSingolaRiga("geec_tabellePrezzi",$this->id);
            $this->nome           = $datiTabella["nome"];
            $this->spazioOccupato = $datiTabella["spazioOccupato"];
        }
        
        function creaElemento($nome,$descrizione,$prezzo) {
            $queryPosizione = "SELECT * FROM geec_colonneTabellaPrezzi WHERE idTabella=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $data = date("Y-m-d");
            $query = "INSERT INTO `geec_colonneTabellaPrezzi` (`id`,`idTabella`,`posizione`,`nome`,`descrizione`,`immagine`, `prezzo`,`prezzoScontato`,`valuta`,`suffisso`,`link`,`etichettaLink`,`numeroClick`,`dataUltimoClick`,`preferita`) "
                    . "VALUES (NULL, '$this->id', '$posizione', '$nome', '$descrizione', '','$prezzo','','','','','','0','$data','no')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function creaElementoColonna($idColonna,$nome,$icona,$classe) {
            $queryPosizione = "SELECT * FROM geec_elementiTabellaPrezzi WHERE idColonna=$idColonna ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_elementiTabellaPrezzi` (`id`,`idColonna`,`posizione`,`nome`,`icona`,`classeElemento`) "
                    . "VALUES (NULL, '$idColonna', '$posizione', '$nome', '$icona', '$classe')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            $query = "SELECT * FROM geec_colonneTabellaPrezzi WHERE idTabella = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                $nomeEscape = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="d-flex">
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left w-100">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["nome"] ?></strong></a></em></p>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <form class="d-inline-flex mr-sm-1">
                            <div class="input-group input-group-sm d-flex align-items-center">
                                <small class="text-muted mr-2">Pos.</small>
                                <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $nomeEscape; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function stampaElementiColonna($idColonna) {
            $query = "SELECT * FROM geec_elementiTabellaPrezzi WHERE idColonna = {$idColonna} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                $nomeEscape = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center">
                    <div class="d-flex">
                        <div class="mb-1 mb-sm-0 text-muted w-50 text-left w-100">
                            <p class="mb-0"><em><a href="javascript:modificaElementoColonna(<?php echo $elemento["id"]; ?>,'<?php echo $elemento["nome"]; ?>','<?php echo $elemento["icona"]; ?>','<?php echo $elemento["classeElemento"]; ?>')""><strong><?php echo $elemento["nome"] ?></strong></a></em></p>
                        </div>
                    </div>
                    <div class="azioni d-flex align-items-center justify-content-end">
                        <form class="d-inline-flex mr-sm-1">
                            <div class="input-group input-group-sm d-flex align-items-center">
                                <small class="text-muted mr-2">Pos.</small>
                                <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class="btn-group" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                            <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="modificaElementoColonna(<?php echo $elemento["id"]; ?>,'<?php echo $nomeEscape; ?>','<?php echo $elemento["icona"]; ?>','<?php echo $elemento["classeElemento"]; ?>')" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                            <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $nomeEscape; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome, $descrizione, $prezzo,$prezzoScontato,$valuta,$suffisso,$link,$etichettaLink,$preferita) {
            $query = "UPDATE geec_colonneTabellaPrezzi SET nome='$nome', descrizione='$descrizione', prezzo='$prezzo', prezzoScontato='$prezzoScontato', valuta='$valuta', suffisso='$suffisso', link='$link', etichettaLink='$etichettaLink', preferita='$preferita' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_colonneTabellaPrezzi WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_colonneTabellaPrezzi SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_colonneTabellaPrezzi SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            
            $query = "SELECT * FROM geec_elementiTabellaPrezzi WHERE idColonna = {$idElemento} ORDER BY posizione ASC";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $this->creaElementoColonna($idContenutoDuplicato,$elementoDaCopiare["nome"],$elementoDaCopiare["icona"],$elementoDaCopiare["classe"]);
            }
            return $idContenutoDuplicato;
        }
        
        function modificaElementoColonna($id,$nome, $icona, $classe) {
            $query = "UPDATE geec_elementiTabellaPrezzi SET nome='$nome', icona='$icona', classeElemento='$classe' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_colonneTabellaPrezzi` SET  immagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_colonneTabellaPrezzi WHERE idTabella=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_colonneTabellaPrezzi SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_colonneTabellaPrezzi SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function spostaElementoColonna($idColonna,$idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_elementiTabellaPrezzi WHERE idColonna=$idColonna AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_elementiTabellaPrezzi SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_elementiTabellaPrezzi SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_colonneTabellaPrezzi",$idElemento);
        }
        
        function eliminaElementoColonna($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_elementiTabellaPrezzi",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

    }